//+------------------------------------------------------------------+
//|                                         Previous Candle Data.mq4 |
//|                                         Copyright  2010, robmrj |
//|                                                  robmrj@yahoo.it |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, robmrj"
#property link      "robmrj@yahoo.it"

#property indicator_chart_window

extern int       timeframe=1440;
extern bool      previous_open=true;
extern bool      previous_close=true;
extern bool      previous_high=false;
extern bool      previous_low=false;
extern bool      previous_median=false;
extern bool      previous_typical=false;
extern bool      previous_weighted=false;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
ObjectsDeleteAll();   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
if(previous_high){double h = iHigh(Symbol(),timeframe,1);lines("h",h,Blue,"HIGH: ",1,0);}
if(previous_low){double l = iLow(Symbol(),timeframe,1);lines("l",l,Red,"LOW: ",1,0);}
if(previous_open){double o = iOpen(Symbol(),timeframe,1);lines("o",o,LightGreen,"OPEN: ",1,0);}
if(previous_close){double c = iClose(Symbol(),timeframe,1);lines("c",c,LightBlue,"CLOSE: ",1,0);}
if(previous_median){double m = (h+l)/2;lines("m",m,Yellow,"MEDIAN: ",1,1);}
if(previous_typical){double t = (h+l+c)/3;lines("t",t,Yellow,"TYPICAL: ",1,1);}
if(previous_weighted){double w = (h+l+(c*2))/4;lines("w",w,Yellow,"WEIGHTED: ",1,1);}

//----
   return(0);
  }
//+------------------------------------------------------------------+

void lines(string name, double l, color c, string t, int b, int st)
{
ObjectDelete(name);
ObjectCreate(name,2,0,Time[0],l,Time[0]+Period()*60*2,l);
ObjectSet(name,OBJPROP_WIDTH,b);
ObjectSet(name,OBJPROP_COLOR, c);
ObjectSet(name,OBJPROP_STYLE,st);
ObjectDelete(name+"t");
ObjectCreate(name+"t", OBJ_TEXT, 0,Time[0]+Period()*60*50, l);
ObjectSetText(name+"t", t + DoubleToStr(l,5), 10, "Courier",Green);
ObjectSet(name+"t",OBJPROP_COLOR,c);
}